import {
  HttpInterceptor,
  HttpRequest,
  HttpHandler,
  HttpEvent,
  HttpResponse,
} from '@angular/common/http';
import { Injectable } from '@angular/core';
import { map, tap } from 'rxjs';

// The JsonParser class acts as a base class for custom parsers and as the DI token.
// @Injectable()
// export abstract class JsonParser {
//   abstract parse(text: string): any;
// }

@Injectable()
export class CustomRequestInterceptor implements HttpInterceptor {
  constructor() {}

  intercept(httpRequest: HttpRequest<any>, next: HttpHandler) {
    const authReq = httpRequest.clone({
      headers: httpRequest.headers
        .set('Access-Control-Allow-Headers', 'Content-Type')
        .set('Access-Control-Allow-Methods', '*')
        .set('Access-Control-Allow-Origin', '*'),
    });
    // if (httpRequest.responseType === 'json') {
    //   // If the expected response type is JSON then handle it here.
    //   //   return this.handleJsonResponse(httpRequest, next);
    //   return next.handle(httpRequest);
    // } else {
    return next.handle(authReq);
    // }
  }
}
