import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { Observable } from 'rxjs';
import { Any } from 'typeorm';
import { PaymentService } from '../payment.service';

@Component({
  selector: 'app-payment',
  templateUrl: './payment.component.html',
  styleUrl: './payment.component.scss',
})
export class PaymentComponent implements OnInit {
  upiBtnContent: boolean = false;
  cardBtnContent: boolean = false;
  cashBtnContent: boolean = true;
  upiBtn: boolean = false;
  cardBtn: boolean = false;
  cashBtn: boolean = false;
  buttonBackgroundColor: boolean = false;
  buttonBackgroundColor1: string = '';
  button1Color = 'white';
  button2Color = 'white';
  button3Color = 'white';
  selectedButton: string | null = null;
  constructor(private Router: Router, private PaymentService: PaymentService) {}
  ngOnInit(): void {}
  onBtnClick() {
    this.Router.navigate(['cart']);
  }
  onPaymentBtnClick(clickedButton: string): void {
    this.upiBtn = false;
    this.cardBtn = false;
    this.cashBtn = false;
    // this.button1Color = 'white';
    // this.button2Color = 'white';
    // this.button3Color = 'white';
    if (clickedButton === 'upiBtn') {
      this.PaymentService.login();
      // .subscribe((response) => {
      //   if (response) {
      // const successResponse = {
      //   status: response.response_code,
      //   token: response.token,
      // };
      // this.PaymentService.QRPayment(successResponse).subscribe(
      //   (response) => {
      //     console.log('========', response);
      //   }
      // );
      //   } else {
      //     console.error('error');
      //   }
      // });
      this.upiBtnContent = !this.upiBtnContent;
      this.button1Color = '#98C6E1';
      this.button2Color = '#7C7B7B';
      this.button3Color = '#7C7B7B';
      this.cardBtn = true;
      this.cashBtn = true;
    } else if (clickedButton === 'cardBtn') {
      this.cardBtnContent = !this.cardBtnContent;
      this.button2Color = '#98C6E1';
      this.button1Color = '#7C7B7B';
      this.button3Color = '#7C7B7B';
      this.cardBtn = true;
      this.cashBtn = true;
    } else if (clickedButton === 'cardBtn') {
      this.button3Color = '#98C6E1';
      this.button1Color = '#7C7B7B';
      this.button2Color = '#7C7B7B';
      this.upiBtn = true;
      this.cardBtn = true;
    }
  }
  crossBtn() {
    this.upiBtnContent = !this.upiBtnContent;
    // this.cardBtnContent = !this.cardBtnContent;
    this.button1Color = 'white';
    this.button2Color = 'white';
    this.button3Color = 'white';
    this.upiBtn = false;
    this.cardBtn = false;
    this.cashBtn = false;
  }
}
