import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { environment } from '../../environments/environment.development';
import CryptoJS, { HmacSHA256, enc } from 'crypto-js';

@Injectable({
  providedIn: 'root',
})
export class PaymentService {
  constructor(private http: HttpClient) {}

  login(): void {
    const credentials = {
      user_id: environment.mswipeUuserName,
      password: environment.mswipePassword,
    };
    this.http
      .post(environment.mswipeLoginAPI, credentials)
      .subscribe((data: any) => {
        console.log('data----', data);
        if (data.response_code == 200) {
          const token = data.token;
          this.QRPayment(token);
        } else {
          console.log('Error');
        }
      });
  }
  generateMacHeader(payload: any) {
    const stringifyRequestBody = JSON.stringify(payload);
    var key = enc.Utf8.parse(environment.mswipeSecretkey);
    var msg = enc.Utf8.parse(stringifyRequestBody);
    var hash = HmacSHA256(msg, key);
    console.log('----', hash);
    var hashInHex = CryptoJS.enc.Base64.stringify(hash);
    console.log('HMAC-SHA256:', hashInHex);
    return hashInHex;
  }
  QRPayment(token: any) {
    // this.login(credentials).subscribe(, credentials:any)
    // const authCode = this.generateMacHeader(requestBody);
    let body = {
      amount: 70.75,
      userid: '8861000328',
      password: '000147',
      custcode: '9401000147',
      InvoiceNo: 'SFL11JOHMQ7A',
      MobileNo: '',
      AddlNote1: '',
      AddlNote2: '',
      AddlNote3: '',
      AddlNote4: '',
      AddlNote5: '',
      AddlNote6: '',
      AddlNote7: '',
      AddlNote8: '',
      AddlNote9: '',
      AddlNote10: '',
    };
    const authCode = this.generateMacHeader(body);
    // let headerJson = {
    //   Authorization: 'xmlCTrZ1hcAeTs6mZmpiHAWSDoUY2sYeRoQzmGBiPf0=',
    //   Accesstoken:
    //     'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJodHRwOi8vc2NoZW1hcy54bWxzb2FwLm9yZy93cy8yMDA1LzA1L2lkZW50aXR5L2NsYWltcy9uYW1lIjoiODg2MTAwMDMyOCIsIlJlcXVlc3RUaW1lIjoiMjAyMy0xMi0wNlQwMDowMDowMCIsImV4cCI6MjAxNzQ5MDE1MiwiaXNzIjoibXN3aXBldGVjaC5jby5pbiIsImF1ZCI6Im1zd2lwZXRlY2guY28uaW4ifQ.W9uxXxW_DtWKXBcgfP3GTSOc-ehvx2ZdtTqTcumC0Zs',
    //   RequestID: '587c1c2d-b8b2-4eee-90d7-4dbd4a0e603e',
    //   Clientkey: 'TqOhI1nr94UoSqT6BXKZPIa1y6qX5jnQ',
    //   'Content-Type': 'application/json; charset=utf-8',
    // };
    // console.log({
    //   Authorization: authCode,
    //   AccessToken: token,
    //   RequestID: '587c1c2d-b8b2-4eee-90d7-4dbd4a0e603e',
    //   Clientkey: environment.mswipeClientKey,
    // });

    if (authCode) {
      const headers = new HttpHeaders({
        Authorization: authCode,
        AccessToken: token,
        RequestID: '587c1c2d-b8b2-4eee-90d7-4dbd4a0e603e',
        Clientkey: environment.mswipeClientKey,
        'Content-Type': 'application/json; charset=utf-8',
      });
      // const header = new HttpHeaders(headers);
      console.log('===', headers);
      this.http
        .post(
          'https://dcuat.mswipetech.co.in/MQR/api/Values/generateDynamicQR',
          body,
          {
            headers: headers,
          }
        )
        .subscribe((response) => {
          console.log('test response', response);
          return response;
        });
    } else {
      console.log('Invalid Authorization code');
    }
  }
}
