import { Component } from '@angular/core';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { AuthenticationService } from '../authentication.service';
import { MatSnackBar } from '@angular/material/snack-bar';

@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrl: './login.component.scss',
})
export class LoginComponent {
  public loginForm: FormGroup;
  constructor(
    public form: FormBuilder,
    private router: Router,
    private authService: AuthenticationService,
    private _snackBar: MatSnackBar
  ) {
    this.loginForm = this.form.group({
      username: ['', [Validators.required]],
      password: ['', [Validators.required]],
    });
  }
  onSubmit() {
    this.authService.doLogin(this.loginForm.value).subscribe(
      (resp) => {
        this._snackBar.open(resp.message, 'close', {
          duration: 2000,
        });
        localStorage['user']=JSON.stringify(resp.data)
        this.router.navigateByUrl("/admin/dashboard")
      },
      (error) => {
        this._snackBar.open(error.message, 'close', {
          duration: 2000,
        });
      },
      () => {}
    );
  }
}
