import { Injectable } from '@angular/core';
import { ElectronService } from 'ad-ngx-electron';
import { Observable } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class AuthenticationService {
  constructor(private _electronService: ElectronService) {}

  doLogin(data: Object): Observable<any> {
    return new Observable((observer: any) => {
      if (this._electronService.isElectronApp) {
        this._electronService?.ipcRenderer
          ?.invoke('login', data)
          .then((resp) => {
            if (resp?.status === 200) {
              observer.next(resp);
            } else {
              observer.error(resp);
            }
          });
      } else {
        observer.error({ message: 'Run the application with electron' });
      }
    });
  }
  // async doLogin(data: Object) {
  //   return new Observable observer=>{

  //   }
  // return new Observable<Object>observer => {
  //   if (this._electronService.isElectronApp) {
  //     let resp = await this._electronService?.ipcRenderer?.invoke(
  //       'login',
  //       data
  //     );
  //     if (resp?.status === 200) {
  //       observer.next(resp);
  //     } else {
  //       observer.error(resp);
  //     }
  //     observer.complete();
  //   } else {
  //     return observer.error({ message: 'Run the application with electron' });
  //   }
  // });
  // }
  // if (this._electronService.isElectronApp) {
  //   // return await this._electronService?.ipcRenderer?.invoke(
  //   //   'login',
  //   //   data
  //   // );
  //     // setInterval(() => observer.next(new Date().toString()), 1000);
  //     // observer.error
  //   });
  // console.log(pong);
  // }
  // }
}
