import { Injectable } from '@angular/core';
import { ElectronService } from 'ad-ngx-electron';
import { Observable } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class LicenseService {
  constructor(private _electronService: ElectronService) {}

  addLicense(data: Object): Observable<any> {
    return new Observable((observer: any) => {
      if (this._electronService.isElectronApp) {
        this._electronService?.ipcRenderer
          ?.invoke('license-add', data)
          .then((resp) => {
            if (resp?.status === 200) {
              observer.next(resp);
            } else {
              observer.error(resp);
            }
          });
      } else {
        observer.error({ message: 'Run the application with electron' });
      }
    });
  }
  licenseList(): Observable<any> {
    return new Observable((observer: any) => {
      if (this._electronService.isElectronApp) {
        this._electronService?.ipcRenderer
          ?.invoke('license-list')
          .then((resp) => {
            if (resp?.status === 200) {
              observer.next(resp);
            } else {
              observer.error(resp);
            }
          });
      } else {
        observer.error({ message: 'Run the application with electron' });
      }
    });
  }
  updateLicense(data:Object): Observable<any> {
    return new Observable((observer: any) => {
      if (this._electronService.isElectronApp) {
        this._electronService?.ipcRenderer
          ?.invoke('update-license',data)
          .then((resp) => {
            if (resp?.status === 200) {
              observer.next(resp);
            } else {
              observer.error(resp);
            }
          });
      } else {
        observer.error({ message: 'Run the application with electron' });
      }
    });
  }
}
