import { Component } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { LicenseAddComponent } from '../license-add/license-add.component';
import { LicenseService } from '../license.service';
import { MatSnackBar } from '@angular/material/snack-bar';
@Component({
  selector: 'app-license-list',
  templateUrl: './license-list.component.html',
  styleUrl: './license-list.component.scss',
})
export class LicenseListComponent {
  displayedColumns: string[] = [
    'position',
    'key',
    'duration',
    // 'terminal',
    'created_at',
    // 'mapped_on',
    // 'expiry_date',
    'is_active',
  ];
  licenseList = [];
  constructor(
    public dialog: MatDialog,
    private _licenseService: LicenseService,
    private _snackBar: MatSnackBar,

  ) {}

  ngOnInit(){
    this.getListOfLicenses()
  }
  openDialog(): void {
    const dialogRef = this.dialog.open(LicenseAddComponent, {
      minWidth: '240px',
      width: '500px',
    });

    dialogRef.afterClosed().subscribe((result) => {
      console.log('The dialog was closed');
    });
  }

  getListOfLicenses() {
    this._licenseService.licenseList().subscribe(
      (resp) => {
        this.licenseList=resp?.data
        console.log(resp)
      },
      (error) => {
        this._snackBar.open(error.message, 'close', {
          duration: 2000,
        });
      },
      () => {}
    );
  } 
   updateStatus(event:any,item:any) {

    item['is_active']=event.checked;
    console.log(event,item)
    this._licenseService.updateLicense(item).subscribe(
      (resp) => {
        this._snackBar.open(resp.message, 'close', {
          duration: 2000,
        });
      },
      (error) => {
        this._snackBar.open(error.message, 'close', {
          duration: 2000,
        });
      },
      () => {}
    );
  }
}
