import { Component } from '@angular/core';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { MatSnackBar } from '@angular/material/snack-bar';
import { AdminService } from '../../admin.service';
import { LicenseService } from '../license.service';
import { MatDialogRef } from '@angular/material/dialog';

@Component({
  selector: 'app-license-add',
  templateUrl: './license-add.component.html',
  styleUrl: './license-add.component.scss',
})
export class LicenseAddComponent {
  public licenseForm: FormGroup;
  constructor(
    public form: FormBuilder,
    private _snackBar: MatSnackBar,
    private _licenseService: LicenseService,
    public dialogRef: MatDialogRef<LicenseAddComponent>,
  ) {
    this.licenseForm = this.form.group({
      key: ['', [Validators.required]],
      duration: [null, [Validators.required,Validators.pattern("[0-9]+")]],
    });
  }
  onSubmit() {
    this._licenseService.addLicense(this.licenseForm.value).subscribe(
      (resp) => {
        this._snackBar.open(resp.message, 'close', {
          duration: 2000,
        });
        this.dialogRef.close()
      },
      (error) => {
        this._snackBar.open(error.message, 'close', {
          duration: 2000,
        });
      },
      () => {}
    );
  }
}
