import { Component } from '@angular/core';
import {
  NavigationEnd,
  Router
} from '@angular/router';
import { filter } from 'rxjs';

@Component({
  selector: 'app-admin-layout',
  templateUrl: './admin-layout.component.html',
  styleUrl: './admin-layout.component.scss',
})
export class AdminLayoutComponent {
  menuList = [
    {
      text: 'Dashboard',
      icon: 'dashboard',
      selected: false,
      link: '/admin/dashboard',
    },
    {
      text: 'License',
      icon: 'card_giftcard',
      selected: false,
      link: '/admin/license',
    },
    {
      text: 'Products',
      icon: 'card_membership',
      selected: false,
      link: '/admin/products',
    },
  ];

  constructor(private router: Router) {
    this.updatedSelectedAddress();
  }

  updatedSelectedAddress() {
    if (!localStorage['user']) this.router.navigateByUrl('/');
    this.router.events
      .pipe(filter((event: any) => event instanceof NavigationEnd))
      .subscribe((event) => {
        this.menuList.forEach((element) => {
          element.selected = false;
        });
        let index = this.menuList.findIndex((a) => a.link == event.url);
        this.menuList[index>=0 ? index : 0].selected = true;
      });
  }
  doLogout(){
    localStorage.removeItem("user");
    this.router.navigateByUrl("/")
  }
}
