import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { AddProductsComponent } from './add-products/add-products.component';
import { DashboardComponent } from './dashboard/dashboard.component';

const routes: Routes = [
  {
    path: 'dashboard',
    component: DashboardComponent,
  },
  {
    path: 'license',
    loadChildren: () =>
      import('./license/license.module').then((m) => m.LicenseModule),
  },
  {
    path: 'products',
    component: AddProductsComponent,
  },
  { path: '', redirectTo: '/admin/dashboard', pathMatch: 'full' },

];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminConsoleRoutingModule {}
