import { Injectable } from '@angular/core';
import { ElectronService } from 'ad-ngx-electron';
import { Observable } from 'rxjs';
import { environment } from '../../environments/environment.development';

@Injectable({
  providedIn: 'root',
})
export class LicenseService {
  constructor(
    private _electronService: ElectronService,
    private http: HttpClient
  ) {}
  private apiUrl = 'http://localhost:8000/users/licenseRead';
  private createLicenseURL = 'http://localhost:8000/users/licenseCreate';
  licenseRead() {
    return this.http.post(this.apiUrl, {});
  }
  saveLicense(data: any) {
    return this.http.post(this.createLicenseURL, data);
  }
  checkLicense(data: Object) {
    return new Observable((observer: any) => {
      if (this._electronService.isElectronApp) {
        this._electronService?.ipcRenderer
          ?.invoke('validate-license', data)
          .then((resp) => {
            if (resp?.status === 200) {
              observer.next(resp);
            } else {
              observer.error(resp);
            }
          });
      } else {
        observer.error({ message: 'Run the application with electron' });
      }
    });
  }
  getAccount(): Observable<any> {
    return this.http.get(`${environment.baseURL}/account`);
  }
  getStore(storeId: any): Observable<any> {
    return this.http.get(`${environment.baseURL}/account/${storeId}/store`);
  }
}
import { HttpClient } from '@angular/common/http';
