import { Component } from '@angular/core';
import {
  FormGroup,
  FormControl,
  Validators,
  FormBuilder,
} from '@angular/forms';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { LicenseService } from '../license.service';

@Component({
  selector: 'app-license-entry',
  templateUrl: './license-entry.component.html',
  styleUrl: './license-entry.component.scss',
})
export class LicenseEntryComponent {
  public licenseForm: FormGroup;
  constructor(
    public form: FormBuilder,
    private router: Router,
    private _licenseService: LicenseService,
    private _snackBar: MatSnackBar
  ) {
    this.licenseForm = this.form.group({
      key: [null, [Validators.required]],
    });
  }
  ngAfterViewInit() {}
  onSubmit() {
    this._licenseService.checkLicense(this.licenseForm.value).subscribe(
      (resp: any) => {
        this._snackBar.open(resp.message, 'close', {
          duration: 2000,
        });
        localStorage['user'] = JSON.stringify(resp.data);

        this.router.navigate(['/', 'home']);
      },
      (error) => {
        this._snackBar.open(error.message, 'close', {
          duration: 2000,
        });
      },
      () => {}
    );
  }
}
