import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { LicenseService } from '../license.service';
@Component({
  selector: 'app-license-entry-form',
  templateUrl: './license-entry-form.component.html',
  styleUrl: './license-entry-form.component.scss',
})
export class LicenseEntryFormComponent implements OnInit {
  public licenseForm: FormGroup;
  account: any;
  store: any;
  constructor(
    public form: FormBuilder,
    private router: Router,
    private _licenseService: LicenseService,
    private _snackBar: MatSnackBar
  ) {
    this.licenseForm = this.form.group({
      accountId: [null, [Validators.required]],
      storeId: [null, [Validators.required]],
      terminalName: [null, [Validators.required]],
      terminalInfo: [null, [Validators.required]],
    });
  }
  ngOnInit(): void {
    this._licenseService.licenseRead().subscribe((resp: any) => {
      console.log('------', resp);
      if (resp.status === 200) {
        this.router.navigate(['/', 'home']);
      }
    });
    this.getAccount();
  }

  onSubmit() {
    console.log('this.licenseForm.value', this.licenseForm.value);
    // this._licenseService.saveLicense(this.licenseForm.value).subscribe(
    //   (resp: any) => {
    //     if (resp.status === 200) {
    //       this._snackBar.open(resp.message, 'close', {
    //         duration: 2000,
    //       });
    //       localStorage['user'] = JSON.stringify(resp);
    //       this.router.navigate(['/', 'home']);
    //     }
    //   }
    //   //   (error: any) => {
    //   //     this._snackBar.open(error.message, 'close', {
    //   //       duration: 2000,
    //   //     });
    //   //   }
    // );
  }
  getAccount() {
    this._licenseService.getAccount().subscribe((resp: any) => {
      this.account = resp.data;
      // console.log('resp-----------', resp.data);
    });
  }
  onAccountChange(accountId: any) {
    const storeId = accountId.value;
    this._licenseService.getStore(storeId).subscribe((resp: any) => {
      this.store = resp.data;
      console.log('resp=========store', resp.data);
    });
    console.log('-----------');
  }
}
