import { Component } from '@angular/core';
import { DateOperation } from '../../utilities/date-operation/date-operation';
import { Router } from '@angular/router';

@Component({
  selector: 'app-sidebar',
  templateUrl: './sidebar.component.html',
  styleUrl: './sidebar.component.scss',
})
export class SidebarComponent {
  days = 450;
  daysLeft: {
    year: Number;
    month: Number;
    day: Number;
  };
  constructor(dateOperation: DateOperation, private router: Router) {
    this.daysLeft = dateOperation.getDaysMonthYearFromDays(this.days);
  }
  licenseEdit() {
    this.router.navigateByUrl('/');
  }
  settingBtnClick() {
    this.router.navigate(['configuration']);
  }
}
