import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { Router, ActivatedRoute, NavigationEnd } from '@angular/router';
import { filter } from 'rxjs/operators';

@Component({
  selector: 'app-header',
  templateUrl: './header.component.html',
  styleUrl: './header.component.scss',
})
export class HeaderComponent implements OnInit {
  @Output() menuToggleEvent = new EventEmitter<boolean>();
  @Input() data: any;
  showButton: boolean;
  constructor(private router: Router, private activatedRoute: ActivatedRoute) {
    this.router.events
      .pipe(filter((event) => event instanceof NavigationEnd))
      .subscribe(() => {
        this.updateButtonVisibility();
      });
  }

  ngOnInit(): void {}
  private updateButtonVisibility() {
    const currentRouteConfig = this.activatedRoute.snapshot.routeConfig;
    const currentRoutePath = currentRouteConfig ? currentRouteConfig.path : '';
    console.log('currentRoutePath', currentRoutePath);
    if (currentRoutePath === 'prediction') {
      this.showButton = true;
    } else {
      this.showButton = false;
    }
  }
  menuClicked() {
    this.menuToggleEvent.emit(true);
  }
  cetegory() {
    this.router.navigate(['category']);
  }
}
