import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable, of } from 'rxjs';
import { MatDialog } from '@angular/material/dialog';
import { SuccessDialogComponent } from '../generic/success-dialog/success-dialog.component';
import { environment } from '../../environments/environment.development';
const productData = {
  predictions: [
    {
      captured_image_path: 'capture\\captured_image1701173376.jpg',
      item_id: '6',
      model_id: 'model',
      pred_confidence: 0.98,
      predict_class: 'Apple Small',
      unique_items_count: 7,
    },
    {
      captured_image_path: 'capture\\captured_image1701173376.jpg',
      item_id: '81',
      model_id: 'model1',
      pred_confidence: 0.95,
      predict_class: 'Mangusteens Indian',
      unique_items_count: 2,
    },
  ],
};

@Injectable({
  providedIn: 'root',
})
export class HomeService {
  constructor(private http: HttpClient, private dialog: MatDialog) {}
  getPredictionDetails(): Observable<any> {
    return of(productData.predictions);
    // const URL = 'http://localhost:8000/users/getPrediction';
    // return this.http.post(`${environment.predictionURL}/predict`, {});
  }
  openSuccessDialog(): void {
    const dialogRef = this.dialog.open(SuccessDialogComponent, {
      width: '300px',
      height: '100px',
    });
    let shouldClose = false;
    setTimeout(() => {
      dialogRef.close();
      shouldClose = true;
    }, 1000);
  }
  getPrediction(): Observable<any> {
    return this.http.post(`${environment.predictionURL}/predict`, {});
  }
}
