import { Component, OnInit, EventEmitter, Output } from '@angular/core';
import { Router } from '@angular/router';
import { CartService } from '../cart.service';
import { ConfirmationDialogComponent } from '../confirmation-dialog/confirmation-dialog.component';
import { MatDialog } from '@angular/material/dialog';

@Component({
  selector: 'app-product-list',
  templateUrl: './product-list.component.html',
  styleUrl: './product-list.component.scss',
})
export class ProductListComponent implements OnInit {
  cartItem!: any[];
  filteredCartItems: any[] = [];
  numberOfItem: number[] = [];
  constructor(
    private router: Router,
    private CartService: CartService,
    public dialog: MatDialog
  ) {
    this.numberOfItem = [];
  }
  ngOnInit(): void {
    this.cartList();
  }

  cartList() {
    this.CartService.getCartItem().subscribe((item) => {
      if (item) {
        this.cartItem = item;
        this.filteredCartItems = this.cartItem.filter(
          (item) => item.status === true
        );
        this.numberOfItem.push(
          this.cartItem.filter((item) => item.status === true).length
        );
      }
    });
  }
  getTotalValue(): number {
    return this.filteredCartItems.reduce(
      (sum, item) => sum + parseFloat(item.amount),
      0
    );
  }
  deleteCartItem() {
    // alert("hello");
  }
  back() {
    this.router.navigate(['home']);
  }
  clearAll($event: any) {
    this.dialog.open(ConfirmationDialogComponent, {
      width: '534px',
      height: '361px',
    });
  }
  openDialog($event: any) {
    this.dialog.open(ConfirmationDialogComponent, {
      width: '534px',
      height: '361px',
    });
  }
  onBtnClick() {
    this.router.navigate(['payment']);
  }
}
