import { NgModule } from '@angular/core';
import {
  BrowserModule,
  provideClientHydration,
} from '@angular/platform-browser';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { LayoutComponent } from './layout/layout.component';
import { HeaderComponent } from './layout/header/header.component';
import { SidebarComponent } from './layout/sidebar/sidebar.component';
import { FooterComponent } from './layout/footer/footer.component';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { MaterialModule } from './shared/material/material.module';
import { ShortcutsDirective } from './directives/shortcuts/shortcuts.directive';
import { DateOperation } from './utilities/date-operation/date-operation';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatCheckboxModule } from '@angular/material/checkbox';
// import { ProductComponent } from './pages/prediction/product/product.component';
// import { CartListComponent } from './pages/cart-list/cart-list/cart-list.component';
// import { ConfirmationDialogComponent } from './pages/dialog/confirmation-dialog/confirmation-dialog.component';
// import { CategoryComponent } from './pages/help/category/category.component';
// import { CategoryListComponent } from './pages/help/category-list/category-list.component';
import { NgxElectronModule } from 'ad-ngx-electron';
// import { PaymentEntryComponent } from './pages/payment/payment-entry/payment-entry.component';
import { HTTP_INTERCEPTORS, HttpClientModule } from '@angular/common/http';
import { CustomRequestInterceptor } from './utilities/interceptor/request-interceptor';
import { SuccessDialogComponent } from './generic/success-dialog/success-dialog.component';
// import { ConfigurationSettingsComponent } from './configuration/configuration-settings/configuration-settings.component';
// import { VarietyComponent } from './help/variety/variety.component';
// import { PaymentComponent } from './payment/payment/payment.component';
// import { ProductListComponent } from './cart/product-list/product-list.component';

@NgModule({
  declarations: [
    AppComponent,
    LayoutComponent,
    HeaderComponent,
    SidebarComponent,
    FooterComponent,
    ShortcutsDirective,
    SuccessDialogComponent,
    // ConfigurationSettingsComponent,
    // ProductComponent,
    // CartListComponent,
    // ConfirmationDialogComponent,
    // CategoryComponent,
    // CategoryListComponent,
    // PaymentEntryComponent,
    // VarietyComponent,
    // PaymentComponent,
    // ProductListComponent,
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    BrowserAnimationsModule,
    MaterialModule,
    FormsModule,
    ReactiveFormsModule,
    NgxElectronModule,
    HttpClientModule,
    MatCheckboxModule,
  ],
  providers: [
    provideClientHydration(),
    DateOperation,
    {
      provide: HTTP_INTERCEPTORS,
      useClass: CustomRequestInterceptor,
      multi: true,
    },
  ],
  bootstrap: [AppComponent],
})
export class AppModule {}
