import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { LayoutComponent } from './layout/layout.component';
import { ProductComponent } from './help/product/product.component';
import { LandingComponent } from './home/landing/landing.component';
import { ConfirmComponent } from './home/confirm/confirm.component';
import { PredictionComponent } from './home/prediction/prediction.component';
import { CategoryComponent } from './help/category/category.component';
import { VarietyComponent } from './help/variety/variety.component';
import { LicenseEntryFormComponent } from './license/license-entry-form/license-entry-form.component';
import { ConfigurationSettingsComponent } from './configuration/configuration-settings/configuration-settings.component';
import { PaymentModeComponent } from './configuration/payment-mode/payment-mode.component';

const routes: Routes = [
  {
    path: '',
    component: LicenseEntryFormComponent,
    loadChildren: () =>
      import('./license/license.module').then((m) => m.LicenseModule),
  },
  {
    path: 'license',
    children: [
      {
        path: '',
        component: LicenseEntryFormComponent,
        loadChildren: () =>
          import('./license/license.module').then((m) => m.LicenseModule),
      },
    ],
  },

  {
    path: 'home',
    component: LayoutComponent,
    children: [
      {
        path: '',
        component: LandingComponent,
        loadChildren: () =>
          import('./home/home.module').then((m) => m.HomeModule),
      },
    ],
  },
  {
    path: 'prediction',
    component: LayoutComponent,
    children: [
      {
        path: '',
        component: PredictionComponent,
        loadChildren: () =>
          import('./home/home.module').then((m) => m.HomeModule),
      },
    ],
  },
  {
    path: 'confirm',
    component: LayoutComponent,
    children: [
      {
        path: '',
        component: ConfirmComponent,
        loadChildren: () =>
          import('./home/home.module').then((m) => m.HomeModule),
      },
    ],
  },
  {
    path: 'cart',
    component: LayoutComponent,
    children: [
      {
        path: '',
        loadChildren: () =>
          import('./cart/cart.module').then((m) => m.CartModule),
      },
    ],
  },
  // {
  //   path: 'cart-list',
  //   component: LayoutComponent,
  //   children: [
  //     {
  //       path: '',
  //       loadChildren: () =>
  //         import('./pages/cart-list/cart-list-routing.module').then(
  //           (m) => m.CartListRoutingModule
  //         ),
  //     },
  //   ],
  // },
  // {
  //   path: 'cetegory',
  //   component: LayoutComponent,
  //   children: [
  //     {
  //       path: '',
  //       loadChildren: () =>
  //         import('./pages/help/category-routing/catetory-routing.module').then(
  //           (m) => m.CatetoryModule
  //         ),
  //     },
  //   ],
  // },
  // {
  //   path: 'cetegory-list',
  //   component: LayoutComponent,
  //   children: [
  //     {
  //       path: '',
  //       loadChildren: () =>
  //         import(
  //           './pages/help/category-routing/catetory-list/catetory-list-routing.module'
  //         ).then((m) => m.CatetoryListModule),
  //     },
  //   ],
  // },
  // {
  //   path: 'cetegory-product',
  //   component: LayoutComponent,
  //   children: [
  //     {
  //       path: '',
  //       loadChildren: () =>
  //         import(
  //           './pages/help/category-routing/product/product-routing.module'
  //         ).then((m) => m.ProductModule),
  //     },
  //   ],
  // },
  {
    path: 'payment',
    // component: LayoutComponent,
    children: [
      {
        path: '',
        loadChildren: () =>
          import('./payment/payment.module').then((m) => m.PaymentModule),
      },
    ],
  },
  {
    path: 'category',
    component: LayoutComponent,
    children: [
      {
        path: '',
        component: CategoryComponent,
        loadChildren: () =>
          import('./help/help-info.module').then((m) => m.HelpInfoModule),
      },
    ],
  },
  {
    path: 'product',
    component: LayoutComponent,
    children: [
      {
        path: '',
        component: ProductComponent,
        loadChildren: () =>
          import('./help/help-info.module').then((m) => m.HelpInfoModule),
      },
    ],
  },
  {
    path: 'variety',
    component: LayoutComponent,
    children: [
      {
        path: '',
        component: VarietyComponent,
        loadChildren: () =>
          import('./help/help-info.module').then((m) => m.HelpInfoModule),
      },
    ],
  },
  {
    path: 'configuration',
    component: LayoutComponent,
    children: [
      {
        path: '',
        component: ConfigurationSettingsComponent,
        loadChildren: () =>
          import('./configuration/configuration.module').then(
            (m) => m.ConfigurationModule
          ),
      },
    ],
  },
  {
    path: 'payment-mode',
    component: LayoutComponent,
    children: [
      {
        path: '',
        component: PaymentModeComponent,
        loadChildren: () =>
          import('./configuration/configuration.module').then(
            (m) => m.ConfigurationModule
          ),
      },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forRoot(routes, { useHash: true })],
  exports: [RouterModule],
})
export class AppRoutingModule {}
