const { ipcMain } = require("electron");
const terminalInfo = require("../../electron/terminal_identify");
module.exports = async (dataSource) => {
  var terminalRepository = dataSource.getRepository("Terminal");

  ipcMain.handle("terminal-add", async (event, data) => {
    try {
      let terminal_info = await terminalInfo();
      let terminal = terminalRepository.create(terminal_info);
      let response = await terminalRepository.save(terminal);
      return Promise.resolve({status:200,data:response,message:"Terminal added successfully"});
    } catch (error) {
      console.log(error)
      return Promise.reject(error);
    }
  });
  ipcMain.handle("terminal-info", async (event, data) => {
    try {
      let terminal = await terminalRepository.find();
      return Promise.resolve(terminal);
    } catch (error) {
      return Promise.reject(error);
    }
  });
};
