const { ipcMain } = require("electron");
const terminalInfo = require("../../electron/terminal_identify");
module.exports = async (dataSource) => {
  var licenseRepository = dataSource.getRepository("License");
  var terminalRepository = dataSource.getRepository("Terminal");

  ipcMain.handle("license-add", async (event, data) => {
    try {
      let license_data = await licenseRepository.findOneBy({
        key: data.key,
      });
      if (license_data) {
        return Promise.resolve({
          status: 200,
          message: "License key already present in database",
        });
      } else {
        let license = await licenseRepository.create(data);
        return Promise.resolve({
          status: 200,
          data: await licenseRepository.save(license),
          message: "License saved successfully",
        });
      }
    } catch (error) {
      console.log(error);
      return Promise.reject({ status: 200, message: "Something went wrong" });
    }
  });
  ipcMain.handle("license-list", async (event, data) => {
    try {
      let license = await licenseRepository.find();
      return Promise.resolve({
        status: 200,
        data: license,
        message: "Success",
      });
    } catch (error) {
      return Promise.reject(error);
    }
  });

  ipcMain.handle("update-license", async (event, data) => {
    try {
      let license = await licenseRepository.save(data);
      return Promise.resolve({
        status: 200,
        data: license,
        message: "Updated Successfully",
      });
    } catch (error) {
      return Promise.reject(error);
    }
  });
  ipcMain.handle("validate-license", async (event, data) => {
    console.log(await terminalInfo())
    try {
      let license = await licenseRepository.findOneBy(data);
      if (license) {
        if (license.is_active) {
          // let terminal= await terminalRepository.save(await terminalInfo())
          license.terminal=await terminalInfo()
          console.log(license)
          await licenseRepository.save(license)
          return Promise.resolve({
            status: 200,
            data: license,
            message: "Valid License",
          });
        } else {
          return Promise.resolve({
            status: 403,
            data: data.key,
            message: "License is not active, contact Admin",
          });
        }
      } else {
        return Promise.resolve({
          status: 403,
          data: data.key,
          message: "Invalid License key",
        });
      }
    } catch (error) {
      console.log(error)
      return Promise.reject(error);
    }
  });
};
