var EntitySchema = require("typeorm").EntitySchema;

module.exports = new EntitySchema({
  name: "Terminal",
  tableName: "terminal",
  columns: {
    id: {
      primary: true,
      type: "int",
      generated: true,
    },
    name: {
      type: "varchar",
      require: true,
    },
    ipv4_mac_address: {
      type: "varchar",
      require: false,
    },
    ipv4_address: {
      type: "varchar",
      require: true,
    },
    ipv6_mac_address: {
      type: "varchar",
      require: false,
    },
    ipv6_address: {
      type: "varchar",
      require: true,
    },
    public_ip: {
      type: "varchar",
      require: true,
    },
    platform: {
      type: "varchar",
      require: true,
    },
    arch: {
      type: "varchar",
      require: true,
    },
    processor: {
      type: "varchar",
      require: true,
    },
    ram: {
      type: "varchar",
      require: true,
    },
    operating_system: {
      type: "varchar",
      require: true,
    },
    created_at: {
      createDate:true
    },
    updated_at: {
      updateDate:true
    },
  },
});
