var EntitySchema = require("typeorm").EntitySchema;

module.exports = new EntitySchema({
  name: "License",
  tableName: "license",
  columns: {
    id: {
      primary: true,
      type: "int",
      generated: true,
    },
    key: {
      type: "varchar",
      require: true,
    },
    duration: {
      type: "int",
      require: true,
    },
    duration: {
      type: "int",
      require: true,
    },
    is_active: {
      type: "boolean",
      require: true,
      default:false
    },
    created_at: {
      createDate:true
    },
    updated_at: {
      updateDate:true
    },
    
  },
  relations: {
    terminal: {
        target: "Terminal",
        type: "one-to-one",
        joinColumn:"id",
        joinTable: true,
        cascade: true,
        require:false,
        
        
    },
},
//   relations: {
//     mappedTo: {
//         target: "Terminal",
//         type: "one-to-one",
//         joinTable: true,
//         cascade: true,
//     },
// },
});
