import * as i0 from '@angular/core';
import { Injectable, NgModule } from '@angular/core';

class ElectronService {
    constructor() {
        this._electron = null;
    }
    get electron() {
        if (!this._electron) {
            if (window && window.require) {
                this._electron = window.require('electron');
                return this._electron;
            }
            return null;
        }
        return this._electron;
    }
    /**
     * determines if SPA is running in Electron
     */
    get isElectronApp() {
        return !!window.navigator.userAgent.match(/Electron/);
    }
    get isMacOS() {
        return this.isElectronApp && process.platform === 'darwin';
    }
    get isWindows() {
        return this.isElectronApp && process.platform === 'win32';
    }
    get isLinux() {
        return this.isElectronApp && process.platform === 'linux';
    }
    get isX86() {
        return this.isElectronApp && process.arch === 'ia32';
    }
    get isX64() {
        return this.isElectronApp && process.arch === 'x64';
    }
    get isArm() {
        return this.isElectronApp && process.arch === 'arm';
    }
    get desktopCapturer() {
        return this.electron ? this.electron.desktopCapturer : null;
    }
    get ipcRenderer() {
        return this.electron ? this.electron.ipcRenderer : null;
    }
    //  TODO FIX : Electron.Remote is readonly so return any instead
    get remote() {
        return this.electron ? this.electron.remote : null;
    }
    get webFrame() {
        return this.electron ? this.electron.webFrame : null;
    }
    get clipboard() {
        return this.electron ? this.electron.clipboard : null;
    }
    get crashReporter() {
        return this.electron ? this.electron.crashReporter : null;
    }
    get process() {
        return this.remote ? this.remote.process : null;
    }
    get nativeImage() {
        return this.electron ? this.electron.nativeImage : null;
    }
    get screen() {
        return this.electron ? (this.remote?.screen ?? null) : null;
    }
    get shell() {
        return this.electron ? this.electron.shell : null;
    }
}

class ElectronServiceRef extends ElectronService {
    constructor() {
        super();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.5", ngImport: i0, type: ElectronServiceRef, deps: [], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "16.2.5", ngImport: i0, type: ElectronServiceRef }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.5", ngImport: i0, type: ElectronServiceRef, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

class NgxElectronModule {
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.5", ngImport: i0, type: NgxElectronModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule }); }
    static { this.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "16.2.5", ngImport: i0, type: NgxElectronModule }); }
    static { this.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "16.2.5", ngImport: i0, type: NgxElectronModule, providers: [{ provide: ElectronService, useClass: ElectronServiceRef }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.5", ngImport: i0, type: NgxElectronModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [],
                    exports: [],
                    providers: [{ provide: ElectronService, useClass: ElectronServiceRef }]
                }]
        }] });

/**
 * Generated bundle index. Do not edit.
 */

export { ElectronService, ElectronServiceRef, NgxElectronModule };
//# sourceMappingURL=ad-ngx-electron.mjs.map
