export class ElectronService {
    constructor() {
        this._electron = null;
    }
    get electron() {
        if (!this._electron) {
            if (window && window.require) {
                this._electron = window.require('electron');
                return this._electron;
            }
            return null;
        }
        return this._electron;
    }
    /**
     * determines if SPA is running in Electron
     */
    get isElectronApp() {
        return !!window.navigator.userAgent.match(/Electron/);
    }
    get isMacOS() {
        return this.isElectronApp && process.platform === 'darwin';
    }
    get isWindows() {
        return this.isElectronApp && process.platform === 'win32';
    }
    get isLinux() {
        return this.isElectronApp && process.platform === 'linux';
    }
    get isX86() {
        return this.isElectronApp && process.arch === 'ia32';
    }
    get isX64() {
        return this.isElectronApp && process.arch === 'x64';
    }
    get isArm() {
        return this.isElectronApp && process.arch === 'arm';
    }
    get desktopCapturer() {
        return this.electron ? this.electron.desktopCapturer : null;
    }
    get ipcRenderer() {
        return this.electron ? this.electron.ipcRenderer : null;
    }
    //  TODO FIX : Electron.Remote is readonly so return any instead
    get remote() {
        return this.electron ? this.electron.remote : null;
    }
    get webFrame() {
        return this.electron ? this.electron.webFrame : null;
    }
    get clipboard() {
        return this.electron ? this.electron.clipboard : null;
    }
    get crashReporter() {
        return this.electron ? this.electron.crashReporter : null;
    }
    get process() {
        return this.remote ? this.remote.process : null;
    }
    get nativeImage() {
        return this.electron ? this.electron.nativeImage : null;
    }
    get screen() {
        return this.electron ? (this.remote?.screen ?? null) : null;
    }
    get shell() {
        return this.electron ? this.electron.shell : null;
    }
}
//# sourceMappingURL=data:application/json;base64,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