/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
/**
 * The DI token for setting the initial config for the platform.
 *
 * @publicApi
 */
export const INITIAL_CONFIG = new InjectionToken('Server.INITIAL_CONFIG');
/**
 * A function that will be executed when calling `renderApplication` or
 * `renderModule` just before current platform state is rendered to string.
 *
 * @publicApi
 */
export const BEFORE_APP_SERIALIZED = new InjectionToken('Server.RENDER_MODULE_HOOK');
//# sourceMappingURL=data:application/json;base64,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