/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
/**
 * Injection token that can be used for a `MatSlider` to provide itself as a
 * parent to the `MatSliderThumb` and `MatSliderRangeThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER = new InjectionToken('_MatSlider');
/**
 * Injection token that can be used to query for a `MatSliderThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER_THUMB = new InjectionToken('_MatSliderThumb');
/**
 * Injection token that can be used to query for a `MatSliderRangeThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER_RANGE_THUMB = new InjectionToken('_MatSliderRangeThumb');
/**
 * Injection token that can be used to query for a `MatSliderVisualThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER_VISUAL_THUMB = new InjectionToken('_MatSliderVisualThumb');
/**
 * A simple change event emitted by the MatSlider component.
 * @deprecated Use event bindings directly on the MatSliderThumbs for `change` and `input` events. See https://material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
export class MatSliderChange {
}
//# sourceMappingURL=data:application/json;base64,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