/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { createSignal, SIGNAL, signalSetFn, signalUpdateFn } from '@angular/core/primitives/signals';
/**
 * Create a `Signal` that can be set or updated directly.
 */
export function signal(initialValue, options) {
    const signalFn = createSignal(initialValue);
    const node = signalFn[SIGNAL];
    if (options?.equal) {
        node.equal = options.equal;
    }
    signalFn.set = (newValue) => signalSetFn(node, newValue);
    signalFn.update = (updateFn) => signalUpdateFn(node, updateFn);
    signalFn.asReadonly = signalAsReadonlyFn.bind(signalFn);
    return signalFn;
}
function signalAsReadonlyFn() {
    const node = this[SIGNAL];
    if (node.readonlyFn === undefined) {
        const readonlyFn = () => this();
        readonlyFn[SIGNAL] = node;
        node.readonlyFn = readonlyFn;
    }
    return node.readonlyFn;
}
//# sourceMappingURL=data:application/json;base64,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