/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { createComputed, SIGNAL } from '@angular/core/primitives/signals';
/**
 * Create a computed `Signal` which derives a reactive value from an expression.
 */
export function computed(computation, options) {
    const getter = createComputed(computation);
    if (options?.equal) {
        getter[SIGNAL].equal = options.equal;
    }
    return getter;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcHV0ZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9jb3JlL3NyYy9yZW5kZXIzL3JlYWN0aXZpdHkvY29tcHV0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBRUgsT0FBTyxFQUFDLGNBQWMsRUFBRSxNQUFNLEVBQUMsTUFBTSxrQ0FBa0MsQ0FBQztBQWN4RTs7R0FFRztBQUNILE1BQU0sVUFBVSxRQUFRLENBQUksV0FBb0IsRUFBRSxPQUFrQztJQUNsRixNQUFNLE1BQU0sR0FBRyxjQUFjLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDM0MsSUFBSSxPQUFPLEVBQUUsS0FBSyxFQUFFO1FBQ2xCLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxLQUFLLEdBQUcsT0FBTyxDQUFDLEtBQUssQ0FBQztLQUN0QztJQUNELE9BQU8sTUFBTSxDQUFDO0FBQ2hCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIExMQyBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuaW1wb3J0IHtjcmVhdGVDb21wdXRlZCwgU0lHTkFMfSBmcm9tICdAYW5ndWxhci9jb3JlL3ByaW1pdGl2ZXMvc2lnbmFscyc7XG5cbmltcG9ydCB7U2lnbmFsLCBWYWx1ZUVxdWFsaXR5Rm59IGZyb20gJy4vYXBpJztcblxuLyoqXG4gKiBPcHRpb25zIHBhc3NlZCB0byB0aGUgYGNvbXB1dGVkYCBjcmVhdGlvbiBmdW5jdGlvbi5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDcmVhdGVDb21wdXRlZE9wdGlvbnM8VD4ge1xuICAvKipcbiAgICogQSBjb21wYXJpc29uIGZ1bmN0aW9uIHdoaWNoIGRlZmluZXMgZXF1YWxpdHkgZm9yIGNvbXB1dGVkIHZhbHVlcy5cbiAgICovXG4gIGVxdWFsPzogVmFsdWVFcXVhbGl0eUZuPFQ+O1xufVxuXG4vKipcbiAqIENyZWF0ZSBhIGNvbXB1dGVkIGBTaWduYWxgIHdoaWNoIGRlcml2ZXMgYSByZWFjdGl2ZSB2YWx1ZSBmcm9tIGFuIGV4cHJlc3Npb24uXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBjb21wdXRlZDxUPihjb21wdXRhdGlvbjogKCkgPT4gVCwgb3B0aW9ucz86IENyZWF0ZUNvbXB1dGVkT3B0aW9uczxUPik6IFNpZ25hbDxUPiB7XG4gIGNvbnN0IGdldHRlciA9IGNyZWF0ZUNvbXB1dGVkKGNvbXB1dGF0aW9uKTtcbiAgaWYgKG9wdGlvbnM/LmVxdWFsKSB7XG4gICAgZ2V0dGVyW1NJR05BTF0uZXF1YWwgPSBvcHRpb25zLmVxdWFsO1xuICB9XG4gIHJldHVybiBnZXR0ZXI7XG59XG4iXX0=