/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/*
 * This file re-exports all symbols contained in this directory.
 *
 * Why is this file not `index.ts`?
 *
 * There seems to be an inconsistent path resolution of an `index.ts` file
 * when only the parent directory is referenced. This could be due to the
 * node module resolution configuration differing from rollup and/or typescript.
 *
 * With commit
 * https://github.com/angular/angular/commit/d5e3f2c64bd13ce83e7c70788b7fc514ca4a9918
 * the `instructions.ts` file was moved to `instructions/instructions.ts` and an
 * `index.ts` file was used to re-export everything. Having had file names that were
 * importing from `instructions' directly (not the from the sub file or the `index.ts`
 * file) caused strange CI issues. `index.ts` had to be renamed to `all.ts` for this
 * to work.
 *
 * Jira Issue = FW-1184
 */
export * from './advance';
export * from './attribute';
export * from './attribute_interpolation';
export * from './change_detection';
export * from './class_map_interpolation';
export * from './component_instance';
export * from './control_flow';
export * from '../../defer/instructions';
export * from './di';
export * from './di_attr';
export * from './element';
export * from './element_container';
export { ɵgetUnknownElementStrictMode, ɵgetUnknownPropertyStrictMode, ɵsetUnknownElementStrictMode, ɵsetUnknownPropertyStrictMode } from './element_validation';
export * from './get_current_view';
export * from './host_property';
export * from './i18n';
export * from './listener';
export * from './namespace';
export * from './next_context';
export * from './projection';
export * from './property';
export * from './property_interpolation';
export * from './storage';
export * from './style_map_interpolation';
export * from './style_prop_interpolation';
export * from './styling';
export * from './template';
export * from './text';
export * from './text_interpolation';
//# sourceMappingURL=data:application/json;base64,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