/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { OpKind } from '../enums';
import { TRAIT_CONSUMES_VARS } from '../traits';
import { NEW_OP } from './shared';
export function createHostPropertyOp(name, expression, isAnimationTrigger, sourceSpan) {
    return {
        kind: OpKind.HostProperty,
        name,
        expression,
        isAnimationTrigger,
        sourceSpan,
        ...TRAIT_CONSUMES_VARS,
        ...NEW_OP,
    };
}
//# sourceMappingURL=data:application/json;base64,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