/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { mapLiteral } from '../output/map_util';
import * as o from '../output/output_ast';
import { Identifiers as R3 } from './r3_identifiers';
import { devOnlyGuardedExpression } from './util';
/**
 * Generate an ngDevMode guarded call to setClassDebugInfo with the debug info about the class
 * (e.g., the file name in which the class is defined)
 */
export function compileClassDebugInfo(debugInfo) {
    const debugInfoObject = {
        className: debugInfo.className,
    };
    // Include file path and line number only if the file relative path is calculated successfully.
    if (debugInfo.filePath) {
        debugInfoObject.filePath = debugInfo.filePath;
        debugInfoObject.lineNumber = debugInfo.lineNumber;
    }
    // Include forbidOrphanRendering only if it's set to true (to reduce generated code)
    if (debugInfo.forbidOrphanRendering) {
        debugInfoObject.forbidOrphanRendering = o.literal(true);
    }
    const fnCall = o.importExpr(R3.setClassDebugInfo).callFn([
        debugInfo.type,
        mapLiteral(debugInfoObject),
    ]);
    const iife = o.arrowFn([], [devOnlyGuardedExpression(fnCall).toStmt()]);
    return iife.callFn([]);
}
//# sourceMappingURL=data:application/json;base64,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