/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { HttpBackend, HttpHandler } from './src/backend';
export { HttpClient } from './src/client';
export { HttpContext, HttpContextToken } from './src/context';
export { FetchBackend } from './src/fetch';
export { HttpHeaders } from './src/headers';
export { HTTP_INTERCEPTORS, HttpInterceptorHandler as ɵHttpInterceptorHandler, HttpInterceptorHandler as ɵHttpInterceptingHandler } from './src/interceptor';
export { JsonpClientBackend, JsonpInterceptor } from './src/jsonp';
export { HttpClientJsonpModule, HttpClientModule, HttpClientXsrfModule } from './src/module';
export { HttpParams, HttpUrlEncodingCodec } from './src/params';
export { HttpFeatureKind, provideHttpClient, withFetch, withInterceptors, withInterceptorsFromDi, withJsonpSupport, withNoXsrfProtection, withRequestsMadeViaParent, withXsrfConfiguration } from './src/provider';
export { HttpRequest } from './src/request';
export { HttpErrorResponse, HttpEventType, HttpHeaderResponse, HttpResponse, HttpResponseBase } from './src/response';
export { withHttpTransferCache as ɵwithHttpTransferCache } from './src/transfer_cache';
export { HttpXhrBackend } from './src/xhr';
export { HttpXsrfTokenExtractor } from './src/xsrf';
// Private exports
export * from './src/private_export';
//# sourceMappingURL=data:application/json;base64,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