/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function createListOfWarnings(warnings) {
    const LINE_START = '\n - ';
    return `${LINE_START}${warnings.filter(Boolean).map(warning => warning).join(LINE_START)}`;
}
export function warnValidation(warnings) {
    (typeof ngDevMode === 'undefined' || ngDevMode) &&
        console.warn(`animation validation warnings:${createListOfWarnings(warnings)}`);
}
export function warnTriggerBuild(name, warnings) {
    (typeof ngDevMode === 'undefined' || ngDevMode) &&
        console.warn(`The animation trigger "${name}" has built with the following warnings:${createListOfWarnings(warnings)}`);
}
export function warnRegister(warnings) {
    (typeof ngDevMode === 'undefined' || ngDevMode) &&
        console.warn(`Animation built with the following warnings:${createListOfWarnings(warnings)}`);
}
export function triggerParsingWarnings(name, warnings) {
    (typeof ngDevMode === 'undefined' || ngDevMode) &&
        console.warn(`Animation parsing for the ${name} trigger presents the following warnings:${createListOfWarnings(warnings)}`);
}
export function pushUnrecognizedPropertiesWarning(warnings, props) {
    if (props.length) {
        warnings.push(`The following provided properties are not recognized: ${props.join(', ')}`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid2FybmluZ19oZWxwZXJzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvYW5pbWF0aW9ucy9icm93c2VyL3NyYy93YXJuaW5nX2hlbHBlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBR0gsU0FBUyxvQkFBb0IsQ0FBQyxRQUFrQjtJQUM5QyxNQUFNLFVBQVUsR0FBRyxPQUFPLENBQUM7SUFDM0IsT0FBTyxHQUFHLFVBQVUsR0FBRyxRQUFRLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLE9BQU8sQ0FBQyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDO0FBQzdGLENBQUM7QUFFRCxNQUFNLFVBQVUsY0FBYyxDQUFDLFFBQWtCO0lBQy9DLENBQUMsT0FBTyxTQUFTLEtBQUssV0FBVyxJQUFJLFNBQVMsQ0FBQztRQUMzQyxPQUFPLENBQUMsSUFBSSxDQUFDLGlDQUFpQyxvQkFBb0IsQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLENBQUM7QUFDdEYsQ0FBQztBQUVELE1BQU0sVUFBVSxnQkFBZ0IsQ0FBQyxJQUFZLEVBQUUsUUFBa0I7SUFDL0QsQ0FBQyxPQUFPLFNBQVMsS0FBSyxXQUFXLElBQUksU0FBUyxDQUFDO1FBQzNDLE9BQU8sQ0FBQyxJQUFJLENBQUMsMEJBQTBCLElBQUksMkNBQ3ZDLG9CQUFvQixDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUMsQ0FBQztBQUM1QyxDQUFDO0FBRUQsTUFBTSxVQUFVLFlBQVksQ0FBQyxRQUFrQjtJQUM3QyxDQUFDLE9BQU8sU0FBUyxLQUFLLFdBQVcsSUFBSSxTQUFTLENBQUM7UUFDM0MsT0FBTyxDQUFDLElBQUksQ0FBQywrQ0FBK0Msb0JBQW9CLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxDQUFDO0FBQ3BHLENBQUM7QUFFRCxNQUFNLFVBQVUsc0JBQXNCLENBQUMsSUFBWSxFQUFFLFFBQWtCO0lBQ3JFLENBQUMsT0FBTyxTQUFTLEtBQUssV0FBVyxJQUFJLFNBQVMsQ0FBQztRQUMzQyxPQUFPLENBQUMsSUFBSSxDQUFDLDZCQUE2QixJQUFJLDRDQUMxQyxvQkFBb0IsQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLENBQUM7QUFDNUMsQ0FBQztBQUVELE1BQU0sVUFBVSxpQ0FBaUMsQ0FBQyxRQUFrQixFQUFFLEtBQWU7SUFDbkYsSUFBSSxLQUFLLENBQUMsTUFBTSxFQUFFO1FBQ2hCLFFBQVEsQ0FBQyxJQUFJLENBQUMseURBQXlELEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDO0tBQzVGO0FBQ0gsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5cbmZ1bmN0aW9uIGNyZWF0ZUxpc3RPZldhcm5pbmdzKHdhcm5pbmdzOiBzdHJpbmdbXSk6IHN0cmluZyB7XG4gIGNvbnN0IExJTkVfU1RBUlQgPSAnXFxuIC0gJztcbiAgcmV0dXJuIGAke0xJTkVfU1RBUlR9JHt3YXJuaW5ncy5maWx0ZXIoQm9vbGVhbikubWFwKHdhcm5pbmcgPT4gd2FybmluZykuam9pbihMSU5FX1NUQVJUKX1gO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gd2FyblZhbGlkYXRpb24od2FybmluZ3M6IHN0cmluZ1tdKTogdm9pZCB7XG4gICh0eXBlb2YgbmdEZXZNb2RlID09PSAndW5kZWZpbmVkJyB8fCBuZ0Rldk1vZGUpICYmXG4gICAgICBjb25zb2xlLndhcm4oYGFuaW1hdGlvbiB2YWxpZGF0aW9uIHdhcm5pbmdzOiR7Y3JlYXRlTGlzdE9mV2FybmluZ3Mod2FybmluZ3MpfWApO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gd2FyblRyaWdnZXJCdWlsZChuYW1lOiBzdHJpbmcsIHdhcm5pbmdzOiBzdHJpbmdbXSk6IHZvaWQge1xuICAodHlwZW9mIG5nRGV2TW9kZSA9PT0gJ3VuZGVmaW5lZCcgfHwgbmdEZXZNb2RlKSAmJlxuICAgICAgY29uc29sZS53YXJuKGBUaGUgYW5pbWF0aW9uIHRyaWdnZXIgXCIke25hbWV9XCIgaGFzIGJ1aWx0IHdpdGggdGhlIGZvbGxvd2luZyB3YXJuaW5nczoke1xuICAgICAgICAgIGNyZWF0ZUxpc3RPZldhcm5pbmdzKHdhcm5pbmdzKX1gKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHdhcm5SZWdpc3Rlcih3YXJuaW5nczogc3RyaW5nW10pOiB2b2lkIHtcbiAgKHR5cGVvZiBuZ0Rldk1vZGUgPT09ICd1bmRlZmluZWQnIHx8IG5nRGV2TW9kZSkgJiZcbiAgICAgIGNvbnNvbGUud2FybihgQW5pbWF0aW9uIGJ1aWx0IHdpdGggdGhlIGZvbGxvd2luZyB3YXJuaW5nczoke2NyZWF0ZUxpc3RPZldhcm5pbmdzKHdhcm5pbmdzKX1gKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHRyaWdnZXJQYXJzaW5nV2FybmluZ3MobmFtZTogc3RyaW5nLCB3YXJuaW5nczogc3RyaW5nW10pOiB2b2lkIHtcbiAgKHR5cGVvZiBuZ0Rldk1vZGUgPT09ICd1bmRlZmluZWQnIHx8IG5nRGV2TW9kZSkgJiZcbiAgICAgIGNvbnNvbGUud2FybihgQW5pbWF0aW9uIHBhcnNpbmcgZm9yIHRoZSAke25hbWV9IHRyaWdnZXIgcHJlc2VudHMgdGhlIGZvbGxvd2luZyB3YXJuaW5nczoke1xuICAgICAgICAgIGNyZWF0ZUxpc3RPZldhcm5pbmdzKHdhcm5pbmdzKX1gKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHB1c2hVbnJlY29nbml6ZWRQcm9wZXJ0aWVzV2FybmluZyh3YXJuaW5nczogc3RyaW5nW10sIHByb3BzOiBzdHJpbmdbXSk6IHZvaWQge1xuICBpZiAocHJvcHMubGVuZ3RoKSB7XG4gICAgd2FybmluZ3MucHVzaChgVGhlIGZvbGxvd2luZyBwcm92aWRlZCBwcm9wZXJ0aWVzIGFyZSBub3QgcmVjb2duaXplZDogJHtwcm9wcy5qb2luKCcsICcpfWApO1xuICB9XG59XG4iXX0=