let os = require("os");
const net = require("net");
const cp = require("child_process");

const getNetworkInterface = (network_info) => {
  return new Promise((resolve, reject) => {
    let ifaces = os.networkInterfaces();

    Object.keys(ifaces).forEach(function (ifname) {
      ifaces[ifname].forEach(function (iface) {
        if (Number(iface.mac.replaceAll(":", "")) != 0) {
          if (iface.family === "IPv4") {
            network_info.ipv4_mac_address = iface.mac;
            network_info.ipv4_address = iface.address;
          } else if (iface.family === "IPv6") {
            network_info.ipv6_mac_address = iface.mac;
            network_info.ipv6_address = iface.address;
          }
        }
      });
    });
    resolve(network_info);
  });
};

const getPublicIp = (terminal_info) => {
  return new Promise((resolve, reject) => {
    var https = require("https");
    https.get(
      {
        host: "api.ipify.org",
      },
      function (response) {
        var ip = "";
        response.on("data", function (d) {
          ip += d;
        });
        response.on("end", function () {
          terminal_info.public_ip = ip;
          resolve();
        });
      }
    );
  });
};

const terminalDetails = (terminal) => {
  return new Promise((resolve, reject) => {
    switch (process.platform) {
      case "win32":
        terminal.name = process.env.COMPUTERNAME;
        terminal.platform = "Windows";
        break;
      case "darwin":
        terminal.name = cp
          .execSync("scutil --get ComputerName")
          .toString()
          .trim();
        terminal.platform = "MacOS";
        break;
      case "linux":
        const prettyname = cp
          .execSync("hostnamectl --pretty")
          .toString()
          .trim();
        terminal.name = prettyname === "" ? os.hostname() : prettyname;
        terminal.platform = "Linux";
        break;
      default:
        terminal.name = os.hostname();
        terminal.platform = "Unknown";
        break;
    }
    terminal.arch = os.arch();
    terminal.processor = os.cpus()[0].model;
    terminal.ram = formatBytes(os.totalmem(), 2);
    terminal.operating_system = os.version();
    terminal.machine = os.machine();
    terminal.operating_system_release = os.release();
    resolve()
  });
};

function formatBytes(bytes, decimals = 2) {
  if (!+bytes) return "0 Bytes";

  const k = 1024;
  const dm = decimals < 0 ? 0 : decimals;
  const sizes = ["Bytes", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"];

  const i = Math.floor(Math.log(bytes) / Math.log(k));

  return `${parseFloat((bytes / Math.pow(k, i)).toFixed(dm))} ${sizes[i]}`;
}

 getTerminalInfo=async () => {
  let terminal_info = {};
  await getNetworkInterface(terminal_info);
  await getPublicIp(terminal_info);
  await terminalDetails(terminal_info);
  return terminal_info;
};


module.exports=getTerminalInfo;