const { app, BrowserWindow, ipcMain, desktopCapturer } = require("electron");
const url = require("url");
const path = require("path");
require("../sqlite");
// require("./terminal_identify");

let mainWindow;

async function createWindow() {
  mainWindow = new BrowserWindow({
    width: 1024,
    height: 768,
    fullscreen: true,
    maximize: true,
    show: false,
    autoHideMenuBar: true,
    icon: __dirname + "../src/favicon.ico",
    webPreferences: {
      nodeIntegration: true,
      contextIsolation: false,
    },
    // webPreferences: {
    //   nodeIntegration: true,
    //   backgroundThrottling: false,
    //   // preload: path.join(__dirname, 'preload.js')
    // },
  });
  // create a new `splash`-window
  splash = new BrowserWindow({
    width: 810,
    height: 610,
    transparent: true,
    frame: false,
    alwaysontop: true,
  });
  splash.loadURL(
    url.format({
      pathname: path.join(__dirname, `./splash.html`),
      protocol: "file:",
      slashes: true,
    })
  );

  mainWindow.loadURL(
    // "http://localhost:4200/"
    url.format({
      pathname: path.join(
        __dirname,
        `../dist/vipos-desktop/browser/index.html`
      ),
      protocol: "file:",
      slashes: true,
    })
  );

  //img.icons8.com/?size=256&id=ipBLdOAQ6sRn&format=png
  // Open the DevTools.
  // https: mainWindow.webContents.openDevTools();

  mainWindow.once("ready-to-show", () => {
    setTimeout(() => {
      splash.destroy();
      mainWindow.show();
    }, 2000);
  });

  mainWindow.on("closed", function () {
    mainWindow = null;
  });
}

app.on("ready", createWindow);

app.on("window-all-closed", function () {
  if (process.platform !== "darwin") app.quit();
});

app.on("activate", function () {
  if (mainWindow === null) createWindow();
});
