import {
  Injectable,
  NgModule,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule
} from "./chunk-5MOQ3LMQ.js";
import "./chunk-BQTYKBYB.js";
import "./chunk-WI6LBH4V.js";
import "./chunk-KDOJNZN6.js";
import "./chunk-FWOMF3V2.js";

// node_modules/ad-ngx-electron/fesm2022/ad-ngx-electron.mjs
var ElectronService = class {
  constructor() {
    this._electron = null;
  }
  get electron() {
    if (!this._electron) {
      if (window && window.require) {
        this._electron = window.require("electron");
        return this._electron;
      }
      return null;
    }
    return this._electron;
  }
  /**
   * determines if SPA is running in Electron
   */
  get isElectronApp() {
    return !!window.navigator.userAgent.match(/Electron/);
  }
  get isMacOS() {
    return this.isElectronApp && process.platform === "darwin";
  }
  get isWindows() {
    return this.isElectronApp && process.platform === "win32";
  }
  get isLinux() {
    return this.isElectronApp && process.platform === "linux";
  }
  get isX86() {
    return this.isElectronApp && process.arch === "ia32";
  }
  get isX64() {
    return this.isElectronApp && process.arch === "x64";
  }
  get isArm() {
    return this.isElectronApp && process.arch === "arm";
  }
  get desktopCapturer() {
    return this.electron ? this.electron.desktopCapturer : null;
  }
  get ipcRenderer() {
    return this.electron ? this.electron.ipcRenderer : null;
  }
  //  TODO FIX : Electron.Remote is readonly so return any instead
  get remote() {
    return this.electron ? this.electron.remote : null;
  }
  get webFrame() {
    return this.electron ? this.electron.webFrame : null;
  }
  get clipboard() {
    return this.electron ? this.electron.clipboard : null;
  }
  get crashReporter() {
    return this.electron ? this.electron.crashReporter : null;
  }
  get process() {
    return this.remote ? this.remote.process : null;
  }
  get nativeImage() {
    return this.electron ? this.electron.nativeImage : null;
  }
  get screen() {
    return this.electron ? this.remote?.screen ?? null : null;
  }
  get shell() {
    return this.electron ? this.electron.shell : null;
  }
};
var _ElectronServiceRef = class _ElectronServiceRef extends ElectronService {
  constructor() {
    super();
  }
};
_ElectronServiceRef.ɵfac = function ElectronServiceRef_Factory(t) {
  return new (t || _ElectronServiceRef)();
};
_ElectronServiceRef.ɵprov = ɵɵdefineInjectable({
  token: _ElectronServiceRef,
  factory: _ElectronServiceRef.ɵfac
});
var ElectronServiceRef = _ElectronServiceRef;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ElectronServiceRef, [{
    type: Injectable
  }], function() {
    return [];
  }, null);
})();
var _NgxElectronModule = class _NgxElectronModule {
};
_NgxElectronModule.ɵfac = function NgxElectronModule_Factory(t) {
  return new (t || _NgxElectronModule)();
};
_NgxElectronModule.ɵmod = ɵɵdefineNgModule({
  type: _NgxElectronModule
});
_NgxElectronModule.ɵinj = ɵɵdefineInjector({
  providers: [{
    provide: ElectronService,
    useClass: ElectronServiceRef
  }]
});
var NgxElectronModule = _NgxElectronModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(NgxElectronModule, [{
    type: NgModule,
    args: [{
      declarations: [],
      exports: [],
      providers: [{
        provide: ElectronService,
        useClass: ElectronServiceRef
      }]
    }]
  }], null, null);
})();
export {
  ElectronService,
  ElectronServiceRef,
  NgxElectronModule
};
//# sourceMappingURL=ad-ngx-electron.js.map
